<?php
// Get Categories
function getCategories()
{
  global $db, $vbulletin, $vbphrase, $categories, $totalrequests;
  $get_categories = $vbulletin->db->query_read("
	                SELECT * FROM " . TABLE_PREFIX . "microrequests_categories
                    ORDER BY displayorder ASC
	                ");
  $categories = '';
  while ($category = $vbulletin->db->fetch_array($get_categories)){
         $activecategory = $category["categoryid"];
         $qry = $vbulletin->db->query_read("
	                SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                    WHERE categoryid=$activecategory");
         $totalrequests = $vbulletin->db->num_rows($qry);
         $totalcats ++;
         eval('$categories .= "' . fetch_template('microrequests_categorybit') . '";');
  }
  return $categories;
}
// Get Latest Open Requests by Category
function getLatestOpen($catid,$showlimit)
{
    global $db, $vbulletin, $vbphrase, $latestopen, $positive, $negative;
    $total_open = 0;
    if($catid==0)
    {
       $get_open = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE status='1'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    } else {
       $get_open = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE categoryid=$catid AND status='1'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    }
    $positive = 0;
    $negative = 0;
    while($open = $db->fetch_array($get_open)){
          $postdate = date($vbulletin->options["microrequests_dateformat"], strtotime($open["postdate"]));
          $catid = getRecordById("microrequests_categories",$open["categoryid"],'categoryid');
          $userid = getRecordById("user",$open["userid"],'userid');
          $status = getRecordById("microrequests_status",$open["status"],'statusid');
          $positive = getCountPositive($open["requestid"]);
          $negative = getCountNegative($open["requestid"]);
          //Change BG Classes
	      if ($total_open%2 == '0'){
	          $rowbg = "alt1";
	      } else {
	          $rowbg = "alt2";
	      }
          $total_open ++;
 		  $seotitle = sanitize_title($open['title']);
          eval('$latestopen .= "' . fetch_template('microrequests_latest_open') . '";');
    }
    return $latestopen;
}
// Get Latest Approved Requests by Category
function getLatestApproved($catid,$showlimit)
{
    global $db, $vbulletin, $vbphrase, $latestapproved, $positive, $negative;
    $total_approved = 0;
    if($catid==0)
    {
       $get_approved = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE status='2'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    } else {
       $get_approved = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE categoryid=$catid AND status='2'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    }
    $positive = 0;
    $negative = 0;
    while($approved = $db->fetch_array($get_approved)){
          $postdate = date($vbulletin->options["microrequests_dateformat"], strtotime($approved["postdate"]));
          $catid = getRecordById("microrequests_categories",$approved["categoryid"],'categoryid');
          $userid = getRecordById("user",$approved["userid"],'userid');
          $status = getRecordById("microrequests_status",$approved["status"],'statusid');
          $positive = getCountPositive($approved["requestid"]);
          $negative = getCountNegative($approved["requestid"]);
          //Change BG Classes
	      if ($total_approved%2 == '0'){
	          $rowbg = "alt1";
	      } else {
	          $rowbg = "alt2";
	      }
          $total_approved ++;
 		  $seotitle = sanitize_title($approved['title']);
          eval('$latestapproved .= "' . fetch_template('microrequests_latest_approved') . '";');
    }
    return $latestapproved;
}
// Get Latest Released Requests by Category
function getLatestReleased($catid,$showlimit)
{
    global $db, $vbulletin, $vbphrase, $latestreleased, $positive, $negative;
    $total_released = 0;
    if($catid==0)
    {
       $get_released = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE status='3'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    } else {
       $get_released = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE categoryid=$catid AND status='3'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    }
    $positive = 0;
    $negative = 0;
    while($released = $db->fetch_array($get_released)){
          $postdate = date($vbulletin->options["microrequests_dateformat"], strtotime($released["postdate"]));
          $catid = getRecordById("microrequests_categories",$released["categoryid"],'categoryid');
          $userid = getRecordById("user",$released["userid"],'userid');
          $status = getRecordById("microrequests_status",$released["status"],'statusid');
          $positive = getCountPositive($released["requestid"]);
          $negative = getCountNegative($released["requestid"]);
          //Change BG Classes
	      if ($total_released%2 == '0'){
	          $rowbg = "alt1";
	      } else {
	          $rowbg = "alt2";
	      }
          $total_released ++;
 		  $seotitle = sanitize_title($released['title']);
          eval('$latestreleased .= "' . fetch_template('microrequests_latest_released') . '";');
    }
    return $latestreleased;
}
// Get Latest Rejected Requests by Category
function getLatestRejected($catid,$showlimit)
{
    global $db, $vbulletin, $vbphrase, $latestrejected, $positive, $negative;
    $total_rejected = 0;
    if($catid==0)
    {
       $get_rejected = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE status='4'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    } else {
       $get_rejected = $db->query_read("
                   SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                   WHERE categoryid=$catid AND status='4'
                   ORDER BY postdate DESC
                   LIMIT $showlimit
                   ");
    }
    $positive = 0;
    $negative = 0;
    while($rejected = $db->fetch_array($get_rejected)){
          $postdate = date($vbulletin->options["microrequests_dateformat"], strtotime($rejected["postdate"]));
          $catid = getRecordById("microrequests_categories",$rejected["categoryid"],'categoryid');
          $userid = getRecordById("user",$rejected["userid"],'userid');
          $status = getRecordById("microrequests_status",$rejected["status"],'statusid');
          $positive = getCountPositive($rejected["requestid"]);
          $negative = getCountNegative($rejected["requestid"]);
          //Change BG Classes
	      if ($total_rejected%2 == '0'){
	          $rowbg = "alt1";
	      } else {
	          $rowbg = "alt2";
	      }
          $total_rejected ++;
 		  $seotitle = sanitize_title($rejected['title']);
          eval('$latestrejected .= "' . fetch_template('microrequests_latest_rejected') . '";');
    }
    return $latestrejected;
}

// Count Positive Votes for specific Request
function getCountPositive($requestid)
{
    global $db, $vbulletin, $vbphrase;
    $total_positive = 0;
    $count_positive = $db->query_read("
                      SELECT * FROM " . TABLE_PREFIX . "microrequests_opinions
                      WHERE requestid=$requestid AND opinion='1'
                      ");
    $total_positive = $db->num_rows($count_positive);
    return $total_positive;
}

// Count Negative Votes for specific Request
function getCountNegative($requestid)
{
    global $db, $vbulletin, $vbphrase;
    $total_negative = 0;
    $count_negative = $db->query_read("
                      SELECT * FROM " . TABLE_PREFIX . "microrequests_opinions
                      WHERE requestid=$requestid AND opinion='2'
                      ");
    $total_negative = $db->num_rows($count_negative);
    return $total_negative;
}


function getRecordById($tablename, $id, $rowname = 'id')
{
  global $db, $vbulletin;
  $result = $db->query_read("SELECT * FROM ".TABLE_PREFIX."".$tablename." WHERE ".$rowname."=".$id." LIMIT 1");
  if(!$result) return array ("id" => 0, "name" => '');
  if(mysql_num_rows($result) == 0) return array ("id" => 0, "name" => '');
  $ret = array();
  while($row = mysql_fetch_assoc($result)) {
    $ret = $row;
  }
  mysql_free_result($result);
  return $ret;
}

function getRequestCategories($categoryid)
{
  global $db, $vbulletin, $vbphrase;
  $categories = $db->query_read("SELECT * FROM ".TABLE_PREFIX."microrequests_categories ORDER BY displayorder");
  $catoptions = '<option value=0 selected=selected>'.$vbphrase["microrequests_select"].'</option>';
  while ($category = $db->fetch_array($categories)) {
         // Set Option Values
	     $option = $category['title'];
	     $optionid = $category['categoryid'];
         // Make Option Selected If Needed
		 unset ($optionselected);
		 if ($category['categoryid'] == $categoryid){
             $optionselected = " selected=selected";
		 }
         // Create List
        $catoptions .= '<option value="' . $optionid . '"' . $optionselected . '>' . $option . '</option>';
  }
  return $catoptions;
}

function getRequestStatuses($statusid)
{
  global $db, $vbulletin, $vbphrase;
  $statuses = $db->query_read("SELECT * FROM ".TABLE_PREFIX."microrequests_status ORDER BY displayorder");
  $statusoptions = '<option value=0 selected=selected>'.$vbphrase["microrequests_select"].'</option>';
  while ($status = $db->fetch_array($statuses)) {
         // Set Option Values
	     $option = $status['title'];
	     $optionid = $status['statusid'];
         // Make Option Selected If Needed
		 unset ($optionselected);
		 if ($status['statusid'] == $statusid){
             $optionselected = " selected=selected";
		 }
         // Create List
        $statusoptions .= '<option value="' . $optionid . '"' . $optionselected . '>' . $option . '</option>';
  }
  return $statusoptions;
}

function expandDate($d)
{
	global $vbulletin;
	if($vbulletin->options["microrequests_inputdateformat"] == 1)
    {
       $date = date('d/m/Y', $d);
    } else {
       $date = date('m/d/Y', $d);
       $hour = intval(date('G', $d));
       $min = intval(date('i', $d));
    }
	return array($date, $hour, $min);
}

function getNumbers($start, $end, $selected)
{
	$options = '';
	for($i = $start; $i <= $end; $i++) {
		$sel = $i == $selected ? 'selected="selected"' : '';
		$options .= '<option value="'.$i.'" '.$sel.' >'.$i.'</option>';
	}
	return $options;
}



function getSearchOrigins()
{
  global $db, $vbulletin, $vbphrase;
  $origins = $db->query_read("SELECT * FROM ".TABLE_PREFIX."microrequests_origins ORDER BY displayorder ASC, name ASC");
  $originoptions = '<option value=-1 selected=selected>'.$vbphrase["microrequests_all"].'</option>';
  while ($origin = $db->fetch_array($origins)) {
         // Set Option Values
	     $option = $origin['name'];
	     $optionid = $origin['id'];
         // Create List
         $originoptions .= '<option value="' . $optionid . '"' . $optionselected . '>' . $option . '</option>';
  }
  return $originoptions;
}


function parseBbCode($bbcode, $limit = 0)
{
  global $vbulletin;
  require_once(DIR . '/includes/class_bbcode.php');
	$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$text = $parser->do_parse($bbcode);
	if($limit != 0) {
		if(strlen($text) > $limit)
			$text = substr($text, 0, $limit).' ...';
	}
  return $text;
}


function sanitize_title($title) {
	$title = strip_tags($title);
	// Preserve escaped octets.
	$title = preg_replace('|%([a-fA-F0-9][a-fA-F0-9])|', '---$1---', $title);
	// Remove percent signs that are not part of an octet.
	$title = str_replace('%', '', $title);
	// Restore octets.
	$title = preg_replace('|---([a-fA-F0-9][a-fA-F0-9])---|', '%$1', $title);
	$title = remove_accents($title);
	if (seems_utf8($title)) {
		if (function_exists('mb_strtolower')) {
			$title = mb_strtolower($title, 'UTF-8');
		}
		$title = utf8_uri_encode($title);
	}
	$title = strtolower($title);
    $title = preg_replace('/&.+?;/', '', $title); // kill entities
	$title = preg_replace('/[^%a-z0-9 _-]/', '', $title);
	$title = preg_replace('/\s+/', '-', $title);
	$title = preg_replace('|-+|', '-', $title);
	$title = trim($title, '-');
	return $title;
}


function remove_accents($string) {
	if (seems_utf8($string)) {
		$chars = array(
		// Decompositions for Latin-1 Supplement
		chr(195).chr(128) => 'A', chr(195).chr(129) => 'A',
		chr(195).chr(130) => 'A', chr(195).chr(131) => 'A',
		chr(195).chr(132) => 'A', chr(195).chr(133) => 'A',
		chr(195).chr(135) => 'C', chr(195).chr(136) => 'E',
		chr(195).chr(137) => 'E', chr(195).chr(138) => 'E',
		chr(195).chr(139) => 'E', chr(195).chr(140) => 'I',
		chr(195).chr(141) => 'I', chr(195).chr(142) => 'I',
		chr(195).chr(143) => 'I', chr(195).chr(145) => 'N',
		chr(195).chr(146) => 'O', chr(195).chr(147) => 'O',
		chr(195).chr(148) => 'O', chr(195).chr(149) => 'O',
		chr(195).chr(150) => 'O', chr(195).chr(153) => 'U',
		chr(195).chr(154) => 'U', chr(195).chr(155) => 'U',
		chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y',
		chr(195).chr(159) => 's', chr(195).chr(160) => 'a',
		chr(195).chr(161) => 'a', chr(195).chr(162) => 'a',
		chr(195).chr(163) => 'a', chr(195).chr(164) => 'a',
		chr(195).chr(165) => 'a', chr(195).chr(167) => 'c',
		chr(195).chr(168) => 'e', chr(195).chr(169) => 'e',
		chr(195).chr(170) => 'e', chr(195).chr(171) => 'e',
		chr(195).chr(172) => 'i', chr(195).chr(173) => 'i',
		chr(195).chr(174) => 'i', chr(195).chr(175) => 'i',
		chr(195).chr(177) => 'n', chr(195).chr(178) => 'o',
		chr(195).chr(179) => 'o', chr(195).chr(180) => 'o',
		chr(195).chr(181) => 'o', chr(195).chr(182) => 'o',
		chr(195).chr(182) => 'o', chr(195).chr(185) => 'u',
		chr(195).chr(186) => 'u', chr(195).chr(187) => 'u',
		chr(195).chr(188) => 'u', chr(195).chr(189) => 'y',
		chr(195).chr(191) => 'y',
		// Decompositions for Latin Extended-A
		chr(196).chr(128) => 'A', chr(196).chr(129) => 'a',
		chr(196).chr(130) => 'A', chr(196).chr(131) => 'a',
		chr(196).chr(132) => 'A', chr(196).chr(133) => 'a',
		chr(196).chr(134) => 'C', chr(196).chr(135) => 'c',
		chr(196).chr(136) => 'C', chr(196).chr(137) => 'c',
		chr(196).chr(138) => 'C', chr(196).chr(139) => 'c',
		chr(196).chr(140) => 'C', chr(196).chr(141) => 'c',
		chr(196).chr(142) => 'D', chr(196).chr(143) => 'd',
		chr(196).chr(144) => 'D', chr(196).chr(145) => 'd',
		chr(196).chr(146) => 'E', chr(196).chr(147) => 'e',
		chr(196).chr(148) => 'E', chr(196).chr(149) => 'e',
		chr(196).chr(150) => 'E', chr(196).chr(151) => 'e',
		chr(196).chr(152) => 'E', chr(196).chr(153) => 'e',
		chr(196).chr(154) => 'E', chr(196).chr(155) => 'e',
		chr(196).chr(156) => 'G', chr(196).chr(157) => 'g',
		chr(196).chr(158) => 'G', chr(196).chr(159) => 'g',
		chr(196).chr(160) => 'G', chr(196).chr(161) => 'g',
		chr(196).chr(162) => 'G', chr(196).chr(163) => 'g',
		chr(196).chr(164) => 'H', chr(196).chr(165) => 'h',
		chr(196).chr(166) => 'H', chr(196).chr(167) => 'h',
		chr(196).chr(168) => 'I', chr(196).chr(169) => 'i',
		chr(196).chr(170) => 'I', chr(196).chr(171) => 'i',
		chr(196).chr(172) => 'I', chr(196).chr(173) => 'i',
		chr(196).chr(174) => 'I', chr(196).chr(175) => 'i',
		chr(196).chr(176) => 'I', chr(196).chr(177) => 'i',
		chr(196).chr(178) => 'IJ',chr(196).chr(179) => 'ij',
		chr(196).chr(180) => 'J', chr(196).chr(181) => 'j',
		chr(196).chr(182) => 'K', chr(196).chr(183) => 'k',
		chr(196).chr(184) => 'k', chr(196).chr(185) => 'L',
		chr(196).chr(186) => 'l', chr(196).chr(187) => 'L',
		chr(196).chr(188) => 'l', chr(196).chr(189) => 'L',
		chr(196).chr(190) => 'l', chr(196).chr(191) => 'L',
		chr(197).chr(128) => 'l', chr(197).chr(129) => 'L',
		chr(197).chr(130) => 'l', chr(197).chr(131) => 'N',
		chr(197).chr(132) => 'n', chr(197).chr(133) => 'N',
		chr(197).chr(134) => 'n', chr(197).chr(135) => 'N',
		chr(197).chr(136) => 'n', chr(197).chr(137) => 'N',
		chr(197).chr(138) => 'n', chr(197).chr(139) => 'N',
		chr(197).chr(140) => 'O', chr(197).chr(141) => 'o',
		chr(197).chr(142) => 'O', chr(197).chr(143) => 'o',
		chr(197).chr(144) => 'O', chr(197).chr(145) => 'o',
		chr(197).chr(146) => 'OE',chr(197).chr(147) => 'oe',
		chr(197).chr(148) => 'R',chr(197).chr(149) => 'r',
		chr(197).chr(150) => 'R',chr(197).chr(151) => 'r',
		chr(197).chr(152) => 'R',chr(197).chr(153) => 'r',
		chr(197).chr(154) => 'S',chr(197).chr(155) => 's',
		chr(197).chr(156) => 'S',chr(197).chr(157) => 's',
		chr(197).chr(158) => 'S',chr(197).chr(159) => 's',
		chr(197).chr(160) => 'S', chr(197).chr(161) => 's',
		chr(197).chr(162) => 'T', chr(197).chr(163) => 't',
		chr(197).chr(164) => 'T', chr(197).chr(165) => 't',
		chr(197).chr(166) => 'T', chr(197).chr(167) => 't',
		chr(197).chr(168) => 'U', chr(197).chr(169) => 'u',
		chr(197).chr(170) => 'U', chr(197).chr(171) => 'u',
		chr(197).chr(172) => 'U', chr(197).chr(173) => 'u',
		chr(197).chr(174) => 'U', chr(197).chr(175) => 'u',
		chr(197).chr(176) => 'U', chr(197).chr(177) => 'u',
		chr(197).chr(178) => 'U', chr(197).chr(179) => 'u',
		chr(197).chr(180) => 'W', chr(197).chr(181) => 'w',
		chr(197).chr(182) => 'Y', chr(197).chr(183) => 'y',
		chr(197).chr(184) => 'Y', chr(197).chr(185) => 'Z',
		chr(197).chr(186) => 'z', chr(197).chr(187) => 'Z',
		chr(197).chr(188) => 'z', chr(197).chr(189) => 'Z',
		chr(197).chr(190) => 'z', chr(197).chr(191) => 's',
		// Euro Sign
		chr(226).chr(130).chr(172) => 'E');
		$string = strtr($string, $chars);
	} else {
		// Assume ISO-8859-1 if not UTF-8
		$chars['in'] = chr(128).chr(131).chr(138).chr(142).chr(154).chr(158)
			.chr(159).chr(162).chr(165).chr(181).chr(192).chr(193).chr(194)
			.chr(195).chr(196).chr(197).chr(199).chr(200).chr(201).chr(202)
			.chr(203).chr(204).chr(205).chr(206).chr(207).chr(209).chr(210)
			.chr(211).chr(212).chr(213).chr(214).chr(216).chr(217).chr(218)
			.chr(219).chr(220).chr(221).chr(224).chr(225).chr(226).chr(227)
			.chr(228).chr(229).chr(231).chr(232).chr(233).chr(234).chr(235)
			.chr(236).chr(237).chr(238).chr(239).chr(241).chr(242).chr(243)
			.chr(244).chr(245).chr(246).chr(248).chr(249).chr(250).chr(251)
			.chr(252).chr(253).chr(255);
		$chars['out'] = "EfSZszYcYuAAAAAACEEEEIIIINOOOOOOUUUUYaaaaaaceeeeiiiinoooooouuuuyy";
		$string = strtr($string, $chars['in'], $chars['out']);
		$double_chars['in'] = array(chr(140), chr(156), chr(198), chr(208), chr(222), chr(223), chr(230), chr(240), chr(254));
		$double_chars['out'] = array('OE', 'oe', 'AE', 'DH', 'TH', 'ss', 'ae', 'dh', 'th');
		$string = str_replace($double_chars['in'], $double_chars['out'], $string);
	}
	return $string;
}


function seems_utf8($Str) { # by bmorel at ssi dot fr
	for ($i=0; $i<strlen($Str); $i++) {
		if (ord($Str[$i]) < 0x80) continue; # 0bbbbbbb
		elseif ((ord($Str[$i]) & 0xE0) == 0xC0) $n=1; # 110bbbbb
		elseif ((ord($Str[$i]) & 0xF0) == 0xE0) $n=2; # 1110bbbb
		elseif ((ord($Str[$i]) & 0xF8) == 0xF0) $n=3; # 11110bbb
		elseif ((ord($Str[$i]) & 0xFC) == 0xF8) $n=4; # 111110bb
		elseif ((ord($Str[$i]) & 0xFE) == 0xFC) $n=5; # 1111110b
		else return false; # Does not match any model
		for ($j=0; $j<$n; $j++) { # n bytes matching 10bbbbbb follow ?
			if ((++$i == strlen($Str)) || ((ord($Str[$i]) & 0xC0) != 0x80))
			return false;
		}
	}
	return true;
}


function utf8_uri_encode( $utf8_string ) {
  $unicode = '';
  $values = array();
  $num_octets = 1;
  for ($i = 0; $i < strlen( $utf8_string ); $i++ ) {
    $value = ord( $utf8_string[ $i ] );
    if ( $value < 128 ) {
      $unicode .= chr($value);
    } else {
      if ( count( $values ) == 0 ) $num_octets = ( $value < 224 ) ? 2 : 3;
      $values[] = $value;
      if ( count( $values ) == $num_octets ) {
      	if ($num_octets == 3) {
      	  $unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]) . '%' . dechex($values[2]);
      	} else {
      	  $unicode .= '%' . dechex($values[0]) . '%' . dechex($values[1]);
     	}
        $values = array();
        $num_octets = 1;
      }
    }
  }
  return $unicode;
}
?>
